/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.apps.taskman.integrator;

import filenet.vw.api.VWException;
import filenet.vw.apps.taskman.VWTaskPropertyChangedEvent;
import filenet.vw.apps.taskman.VWTaskTabPanel;
import filenet.vw.apps.taskman.integrator.VWManagerNode;
import filenet.vw.apps.taskman.integrator.resources.VWResource;
import filenet.vw.base.VWDebug;
import filenet.vw.toolkit.utils.VWHelp;
import filenet.vw.toolkit.utils.images.VWImageLoader;
import filenet.vw.toolkit.utils.uicontrols.border.IVWToolbarBorderActionListener;
import filenet.vw.toolkit.utils.uicontrols.border.VWToolbarBorder;
import filenet.vw.toolkit.utils.uicontrols.border.VWToolbarBorderActionEvent;
import filenet.vw.toolkit.utils.uicontrols.border.VWToolbarBorderClientActionEvent;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.filechooser.FileFilter;

public class VWRequiredLibraryPanel
extends VWTaskTabPanel
implements ActionListener,
ListSelectionListener,
IVWToolbarBorderActionListener {
    private VWManagerNode m_node = null;
    private JList m_list = null;
    private DefaultListModel m_listModel = null;
    private VWToolbarBorder m_listBorder = null;
    private JButton m_upButton = null;
    private JButton m_downButton = null;
    private JFileChooser m_chooser = null;
    private static Dimension BUTTON_SIZE = new Dimension(100, 25);

    public VWRequiredLibraryPanel(String[] libraries, VWManagerNode node) {
        this.m_node = node;
        this.initLayout();
        this.setLibraries(libraries);
        this.updateState();
    }

    public String[] getLibraries() {
        if (this.m_listModel.size() == 0) {
            return null;
        }
        String[] libs = new String[this.m_listModel.size()];
        for (int i = 0; i < this.m_listModel.size(); ++i) {
            libs[i] = ((String)this.m_listModel.elementAt(i)).trim();
        }
        return libs;
    }

    public void setLibraries(String[] libraries) {
        this.m_listModel.clear();
        if (libraries != null) {
            for (int i = 0; i < libraries.length; ++i) {
                this.m_listModel.addElement(" " + libraries[i]);
            }
        }
    }

    private void initLayout() {
        this.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        this.m_listBorder = new VWToolbarBorder(VWResource.LibraryPaths, 0x10000010);
        this.m_listBorder.addToolbarBorderActionNotifier(this);
        JPanel clientPanel = this.m_listBorder.getClientPanel();
        clientPanel.setLayout(new BorderLayout());
        JPanel listPanel = new JPanel(new BorderLayout());
        this.m_listModel = new DefaultListModel();
        this.m_list = new JList(this.m_listModel);
        this.m_list.setSelectionMode(2);
        this.m_list.addListSelectionListener(this);
        listPanel.add((Component)this.m_list, "Center");
        clientPanel.add((Component)new JScrollPane(listPanel, 20, 30), "Center");
        c.fill = 1;
        c.anchor = 23;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.insets = new Insets(0, 0, 0, 5);
        c.gridx = 0;
        c.gridy = 0;
        this.add((Component)this.m_listBorder, c);
        c.fill = 1;
        c.anchor = 23;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.weightx = 0.0;
        c.weighty = 1.0;
        c.insets = new Insets(0, 0, 0, 0);
        c.gridx = 1;
        c.gridy = 0;
        this.add((Component)this.createMoveUpDownButtonPanel(), c);
    }

    protected JPanel createMoveUpDownButtonPanel() {
        JPanel panel = null;
        try {
            panel = new JPanel(new GridBagLayout());
            GridBagConstraints gbCons = new GridBagConstraints();
            gbCons.anchor = 10;
            gbCons.fill = 0;
            gbCons.gridx = 0;
            gbCons.gridy = -1;
            gbCons.gridwidth = 1;
            gbCons.gridheight = 1;
            gbCons.weightx = 0.0;
            gbCons.weighty = 0.0;
            gbCons.insets = new Insets(3, 0, 3, 0);
            this.m_upButton = new JButton(VWImageLoader.createImageIcon("up.gif"));
            this.m_upButton.setToolTipText(VWResource.MoveUp);
            this.m_upButton.setMargin(new Insets(1, 1, 1, 1));
            this.m_upButton.addActionListener(this);
            panel.add((Component)this.m_upButton, gbCons);
            this.m_downButton = new JButton(VWImageLoader.createImageIcon("down.gif"));
            this.m_downButton.setToolTipText(VWResource.MoveDown);
            this.m_downButton.setMargin(new Insets(1, 1, 1, 1));
            this.m_downButton.addActionListener(this);
            panel.add((Component)this.m_downButton, gbCons);
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
        return panel;
    }

    public void updateState() {
        if (!this.m_node.isStarted()) {
            boolean multiSelection;
            int index = this.m_list.getSelectedIndex();
            boolean itemSelected = index != -1;
            boolean bl = multiSelection = itemSelected && this.m_list.getSelectedIndices().length > 1;
            if (index == 0 || multiSelection) {
                this.m_upButton.setEnabled(false);
            } else {
                this.m_upButton.setEnabled(itemSelected);
            }
            if (index == this.m_list.getModel().getSize() - 1 || multiSelection) {
                this.m_downButton.setEnabled(false);
            } else {
                this.m_downButton.setEnabled(itemSelected);
            }
            this.m_listBorder.clientActionPerformed(new VWToolbarBorderClientActionEvent(this.m_listBorder.getClientPanel(), 2, Integer.MAX_VALUE));
            this.m_listBorder.clientActionPerformed(new VWToolbarBorderClientActionEvent(this.m_listBorder.getClientPanel(), 1, 16));
            if (itemSelected) {
                this.m_listBorder.clientActionPerformed(new VWToolbarBorderClientActionEvent(this.m_listBorder.getClientPanel(), 1, 0x10000000));
            }
            this.m_list.setEnabled(true);
        } else {
            this.m_listBorder.clientActionPerformed(new VWToolbarBorderClientActionEvent(this.m_listBorder.getClientPanel(), 2, Integer.MAX_VALUE));
            this.m_upButton.setEnabled(false);
            this.m_downButton.setEnabled(false);
            this.m_list.setEnabled(false);
        }
    }

    public void valueChanged(ListSelectionEvent event) {
        this.updateState();
    }

    public void toolbarBorderActionPerformed(VWToolbarBorderActionEvent event) {
        try {
            int id = event.getID();
            switch (id) {
                case 16: {
                    if (this.m_chooser == null) {
                        this.m_chooser = new JFileChooser();
                        this.m_chooser.setFileFilter(new FileFilter(){

                            public boolean accept(File file) {
                                return file.isDirectory() || file.getAbsolutePath().endsWith(".jar");
                            }

                            public String getDescription() {
                                return "*.jar";
                            }
                        });
                        this.m_chooser.setDialogTitle(VWResource.SelectJarFile);
                        this.m_chooser.setFileSelectionMode(2);
                        this.m_chooser.setAcceptAllFileFilterUsed(false);
                    }
                    this.m_chooser.setSelectedFile(new File(""));
                    int returnVal = this.m_chooser.showOpenDialog(this.m_node.getTaskCore().getMainFrame());
                    if (returnVal != 0) break;
                    File file = this.m_chooser.getSelectedFile();
                    if (file.exists() && (file.isDirectory() || file.getPath().endsWith(".jar"))) {
                        this.m_listModel.addElement(" " + file.getPath());
                        this.taskPropertyChanged(new VWTaskPropertyChangedEvent((Object)this, null));
                        break;
                    }
                    throw new VWException("filenet.vw.apps.taskman.integrator.VWRequiredLibraryPanel.InvalidFile", "Invalid library path: {0}", file.getPath());
                }
                case 0x10000000: {
                    int[] indexes = this.m_list.getSelectedIndices();
                    for (int i = indexes.length - 1; i >= 0; --i) {
                        this.m_listModel.remove(indexes[i]);
                    }
                    if (indexes.length == 1) {
                        if (indexes[0] < this.m_listModel.size()) {
                            this.m_list.setSelectedIndex(indexes[0]);
                        } else if (this.m_listModel.size() > 0) {
                            this.m_list.setSelectedIndex(indexes[0] - 1);
                        }
                    }
                    this.taskPropertyChanged(new VWTaskPropertyChangedEvent((Object)this, null));
                }
            }
        }
        catch (Exception ex) {
            this.m_node.displayError(ex);
        }
    }

    public void actionPerformed(ActionEvent event) {
        try {
            String actionCMD = event.getActionCommand();
            int index = this.m_list.getSelectedIndex();
            if (event.getSource() == this.m_upButton) {
                String lib = (String)this.m_listModel.remove(index);
                this.m_listModel.add(index - 1, lib);
                this.m_list.setSelectedIndex(index - 1);
            } else if (event.getSource() == this.m_downButton) {
                String lib = (String)this.m_listModel.remove(index);
                this.m_listModel.add(index + 1, lib);
                this.m_list.setSelectedIndex(index + 1);
            }
            this.taskPropertyChanged(new VWTaskPropertyChangedEvent((Object)this, null));
        }
        catch (Exception ex) {
            this.m_node.displayError(ex);
        }
    }

    public String getHelpPage() {
        return VWHelp.Help_Process_TaskManager + "cm_config_libraries.htm";
    }
}

